// main.m

#import <Foundation/NSAutoreleasePool.h>
#import <Foundation/NSString.h>
#import <stdio.h>
#import "Person.h"

int main(int argc, const char* argv[])
{
	/*
	 * alloc reserves memory space for an object
	 * NSAutoReleasePool is an automated Garbage collection mechanism
     */
	NSAutoreleasePool* pool = [ [NSAutoreleasePool alloc] init];
	NSString* name = [NSString stringWithString: @"Barb"];
	Person* Barb = [ [Person alloc] initWithName: name andAge: 500];
	
	/*
	 * printf can't handle NSStrings so we use UTF8String to return a char array
     */
	printf("Name:\t%s\n", [ [Barb name] UTF8String] );
	printf("Age:\t%d\n", [Barb age] );
	printf("\n%s\n", [ [Barb speak] UTF8String] );
	
	[Barb release];
	
	return 0;
}

