// Person.m

#import "Person.h"

@implementation Person

-(Person*) initWithName: (NSString*) n andAge: (int) a
{
	/*
	 * Methods are called with [<CLASS> <METHOD>];
	 * init is a method provided by NSObject that provides a default constructor
	 */
	self = [super init];
	
	
	/*
	 * if the super constructor returned a success, continue initialization
	*/
	
	if (self)
	{
		/*
		 * release and retain are memory management methods
		 * retain increments the count of pointers to a location in memory
		 * release does the opposite
		 * Once the count is zero the memory is released
		 */
		[n retain];
		[name release];
		name = n;
		
		/*
		 * age is simply an int, and not a pointer
		 * so it's pass-by-value
		 */
		age = a;
	}
	
	/*
	 * self is analagous to "this" in C++/Java
	 */
	return self;
}

-(NSString*) name
{
	return name;
}

-(int) age
{
	return age;
}

-(NSString*) speak
{
	/*
	 * stringWithFormat creates a new string using printf format
	 * %@ inserts an NSObject
	 * and you don' need to call the init method here, because the 
	 @ preceding the string constant initializes the string for you
	 */
	NSString* result = [ [NSString alloc] initWithFormat:@"Hi.  My name is %@ and my age is %d.",
						name, age];
	
	return result;
	
}

@end

