// Person.h

/*
 * Objective C uses #import instead of #include
*/
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

/*
 * Inheritance in Objective C is shown by a classname
 * followed by a colon followed by another classname
 * NSObject is the superclass for every Objective C class, either directly or indirectly
*/
@interface Person: NSObject
{
	//Instance data are declared here:
	@private
		NSString* name;
		int age;
}

//Methods are declared here:

/*
 * Methods are defined like this
 * -(<RETURN_TYPE>) <DESCRIPTION>: (<ARG_TYPE>) <ARG_NAME>
*/
-(Person*) initWithName: (NSString*) n andAge: (int) a;

-(NSString*) name;

-(int) age;

-(NSString*) speak;

@end

