/* We need to implement in our implementation file, by using @synthesize. */

/* Think of it like this, @property replaces all of the interface method declarations
   for getters and setters, and @synthesize replaces the actual methods themselves.
   The getters and setters are now dynamically created and we don’t need to waste time
   creating them unless we need to do something really special. 
*/

#import "SimpleCar2.h"  
      
@implementation SimpleCar2  
      
@synthesize make, model, vin;  
      
- (void) setMake: (NSString*)newMake andModel: (NSString*)newModel {  
          
  [self setMake:newMake];  
  [self setModel:newModel];    
}  
      
@end