/* A lot of what we did in the first class seems quite pointless and excessive.
   For example, in our getter methods all we are doing is returning an instance variable
   and this takes up three lines of code to do something simple. Also, in our setter
   methods, we are just setting instance variables, essentially all of our methods,
   except our method that takes two arguments, seem bloated and in the way.
   
   Objective-C solves this with @property and @synthesize, which replace our accessor
   methods and make for much neater coding.
*/

#import <Cocoa/Cocoa.h>

@interface SimpleCar2 : NSObject {
    
 NSString* make;  
 NSString* model;  
 NSNumber* vin;  
}  
      
@property(readwrite, retain) NSString* make;  
@property(readwrite, retain) NSString* model;  
@property(readwrite, retain) NSNumber* vin;  
      
    // convenience method  
- (void) setMake: (NSString*)newMake   
            andModel: (NSString*)newModel;  
      
@end
    
/*    What’s happening with the @property declarations? First we tell the compiler we
      are declaring a property by using @property, then we follow with attributes for
      this property. The attributes are the read/write status of a property and some
      memory management. We have used readwrite for all, which means getter and setter
      methods are dynamically created for our instance variables.
*/
    
    