
#import <Cocoa/Cocoa.h>  
#import "SimpleCar.h"

  @implementation SimpleCar  
      
// set methods  
- (void) setVin: (NSNumber*)newVin {  
    
 //  "release" is not needed for automatic reference counting
       
    [vin release];  
    vin = [[NSNumber alloc] init];  
    vin = newVin;  
    
}  

- (void) setMake: (NSString*)newMake {  
    
    [make release];  
    make = [[NSString alloc] initWithString:newMake];  
    
}  

- (void) setModel: (NSString*)newModel {  
    
    [model release];  
    model = [[NSString alloc] initWithString:newModel];  
    
}  

// convenience method  
- (void) setMake: (NSString*)newMake   
        andModel: (NSString*)newModel {  
    
    // Reuse our methods from earlier  
    [self setMake:newMake];  
    [self setModel:newModel];  
    
}
// get methods  

- (NSString*) make {  
        return make;
    }  
      
- (NSString*) model {  
        return model;
    }  
      
- (NSNumber*) vin {
        return vin;
    }  
   
/* Because we actually allocated memory for our objects in the setter methods, we need to be sure we
   release them when the object is released from memory. To do this, we need to add a custom dealloc
   method */
 
 -(void) dealloc  
 {  
    [vin release];  
    [make release];  
    [model release];  
    [super dealloc];  
 }  

@end
    
