//
//  ViewController.m
//  Clock
//
//  Created by Barbara Hecker on 11/6/12.
//  Copyright (c) 2012 Barbara Hecker. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()

@end

@implementation ViewController

@synthesize clockDisplay, counterTime;

- (void)viewDidLoad
{
    [self runTimer];
    [super viewDidLoad];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (void)runTimer {
    // This starts the timer which fires the showActivity
    // method every 0.5 seconds
    myTicker = [NSTimer scheduledTimerWithTimeInterval: 0.5 target: self selector: @selector(showActivity) userInfo: nil repeats: YES];
}

// This method is run every 0.5 seconds by the timer created
// in the function runTimer
- (void)showActivity {
    
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    NSDate *date = [NSDate date];
    
    // This will produce a time that looks like "12:15:00 PM".
    [formatter setTimeStyle:NSDateFormatterMediumStyle];
    
    // This sets the label with the updated time.
    [clockDisplay setText:[formatter stringFromDate:date]];
}
- (IBAction)startButton:(UIButton *)sender {
    myTicker = [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(showTimerActivity) userInfo:nil repeats:YES];
}

- (IBAction)stopButton:(UIButton *)sender {
    [myTicker invalidate];
    myTicker = nil;
}

-(void)showTimerActivity;
{
    counter += 1;
    int hours = counter / 3600;
    int minutes = counter / 60 - hours * 60;
    int seconds = counter - hours * 3600 - minutes * 60;
    counterTime.text = [NSString stringWithFormat:@"%02d:%02d:%02d", hours, minutes, seconds];
}

@end
