
#import "TBURLController.h"

@implementation TBURLController

- (id)init
{
	if (![super init]) {
		return nil;
	}
	urls = [[NSMutableArray alloc] init];
    
	[urls addObject:[NSURL URLWithString:@"http://www.google.com"]];
    [urls addObject:[NSURL URLWithString:@"http://www.itu.edu"]];
    [urls addObject:[NSURL URLWithString:@"http://www.bhecker.com"]];
    
	return self;
}

- (void)awakeFromNib
{
	[tableView registerForDraggedTypes:[NSArray arrayWithObject:NSURLPboardType]];
	[tableView setDraggingSourceOperationMask:NSDragOperationCopy forLocal:NO];
}

- (NSInteger)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return [urls count];
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(NSInteger)rowIndex
{
	return [urls objectAtIndex:rowIndex];
}

- (void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
	if ([tableView selectedRow] == -1) {
		[webView setMainFrameURL:@"about:blank"];
	} else {
		NSURL *url = [urls objectAtIndex:[tableView selectedRow]];
		[webView setMainFrameURL:[url absoluteString]];
	}
}

- (BOOL)tableView:(NSTableView *)aTableView acceptDrop:(id < NSDraggingInfo >)info row:(NSInteger)row dropOperation:(NSTableViewDropOperation)operation
{
	NSPasteboard *pboard = [info draggingPasteboard];
	NSURL *url = [NSURL URLFromPasteboard:pboard];
	[urls addObject:url];
	[tableView reloadData];
	return YES;
}

- (NSDragOperation)tableView:(NSTableView *)aTableView validateDrop:(id < NSDraggingInfo >)info proposedRow:(NSInteger)row proposedDropOperation:(NSTableViewDropOperation)operation
{
	if ([info draggingSource] == tableView) {
		return NSDragOperationNone;
	} else {
		return NSDragOperationAll;
	}
}

- (void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(NSInteger)rowIndex
{
	[urls replaceObjectAtIndex:rowIndex withObject:[NSURL URLWithString:anObject]];
	NSURL *url = [urls objectAtIndex:[tableView selectedRow]];
	[webView setMainFrameURL:[url absoluteString]];
}
- (BOOL)tableView:(NSTableView *)aTableView writeRowsWithIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard *)pboard
{
	[pboard declareTypes:[NSArray arrayWithObject:NSURLPboardType] owner:nil];
	[[urls objectAtIndex:[rowIndexes firstIndex]] writeToPasteboard:pboard];
	return YES;
}

@end
