// Test.java
// Test Point, Circle, Cylinder hierarchy with interface Shape.

// Java core packages
import java.text.DecimalFormat;

// Java extension packages
import javax.swing.JOptionPane;

public class Test {
    static DecimalFormat precision2 = new DecimalFormat( "0.00" );
  
    public static void outputInformation(Shape s) {
	String output = "\n\n" + s.getName() + ": " + s.toString() +
            "\nArea = " + precision2.format( s.area() ) +
            "\nVolume = " + precision2.format( s.volume() );

	System.out.println(output);
    }

   // test Shape hierarchy
   public static void main( String args[] )
   {
      // create shapes
      Point point = new Point( 7, 11 );          
      Circle circle = new Circle( 3.5, 22, 8 );  
      Cylinder cylinder = new Cylinder( 10, 3.3, 10, 10 );

      // create Shape array 
      Shape arrayOfShapes[] = new Shape[ 3 ];

      // aim arrayOfShapes[ 0 ] at subclass Point object
      arrayOfShapes[ 0 ] = point;

      // aim arrayOfShapes[ 1 ] at subclass Circle object
      arrayOfShapes[ 1 ] = circle;

      // aim arrayOfShapes[ 2 ] at subclass Cylinder object
      arrayOfShapes[ 2 ] = cylinder;  

      // get name and String representation of each shape
      String output ="";

      // loop through arrayOfShapes and get name,
      // area and volume of each shape in arrayOfShapes
      // and print this information out
      for ( int i = 0; i < arrayOfShapes.length; i++ ) {
	  outputInformation(arrayOfShapes[i]);
      }

      System.exit( 0 );
   }
}  // end class Test