function load()
{
    dashcode.setupParts();
}

function Model() {
    this.board="012345678";
    this.player='O';
}

function move( n ) {
    if(win()) return;
    if( model.board.charAt(n)=='X' || model.board.charAt(n)=='O') return false;
    var button = 'button'+n;
    document.getElementById(button).object.setText(model.player);
    model.board = model.board.substr(0,n) + model.player + model.board.substr(n+1,9-n);
    if(win()) return;
    if(model.player == 'X')
        model.player='O';
    else
        model.player='X';
    //document.getElementById("Player").innerText = model.player + " play";
    return true;
}

function win() {
    var wins = "012345678036147258048246";
    for (awin=0; awin<8; awin++) {
        i0 = parseInt(wins.charAt(awin*3));
        i1 = parseInt(wins.charAt(awin*3+1));
        i2 = parseInt(wins.charAt(awin*3+2));			
        if (model.board.charAt(i0) == model.board.charAt(i1) &&	model.board.charAt(i1) == model.board.charAt(i2) ) {
            document.getElementById("Player").innerText = model.player + " wins!";
            return true;
        }
    }
    return false;
}

var model = new Model();

function controller( n ) 
{
    if(!move(n)) return;
    var feedURL = "http://192.168.1.64:1490/?"+model.board;						// The feed to fetch
    var onloadHandler = function() { xmlLoaded(xmlRequest); };	
    // XMLHttpRequest setup code
    var xmlRequest = new XMLHttpRequest();
    xmlRequest.onload = onloadHandler;
    xmlRequest.open("GET", feedURL, true);
    xmlRequest.setRequestHeader("Cache-Control", "no-cache");
    xmlRequest.send(null);
}

// Called when an XMLHttpRequest loads a feed; works with the XMLHttpRequest setup snippet
function xmlLoaded(xmlRequest) 
{document.getElementById("Player").innerText = xmlRequest.responseText;
	if (xmlRequest.status == 200) {
        var n = parseInt(xmlRequest.responseText);
        if(n==9) return;
        var button = 'button'+n;
        move(n);
	}
	else {
		alert("Error fetching data: HTTP status " + xmlRequest.status);
	}
}

function clickHandler0(event){    controller(0);}
function clickHandler1(event){    controller(1);}
function clickHandler2(event){    controller(2);}
function clickHandler3(event){    controller(3);}
function clickHandler4(event){    controller(4);}
function clickHandler5(event){    controller(5);}
function clickHandler6(event){    controller(6);}
function clickHandler7(event){    controller(7);}
function clickHandler8(event){    controller(8);}
