var host = "localhost";
var model = new Model();
var controller = new Controller();

function load()
{
    dashcode.setupParts();
}

function Model() {
    this.board="012345678";
    this.player='O';
    this.win = function() {
        var wins = "012345678036147258048246";
        for (awin=0; awin<8; awin++) {
            i0 = parseInt(wins.charAt(awin*3));
            i1 = parseInt(wins.charAt(awin*3+1));
            i2 = parseInt(wins.charAt(awin*3+2));			
            if (this.board.charAt(i0) == this.board.charAt(i1) && this.board.charAt(i1) == this.board.charAt(i2) ) 
                return true;
        }
        return false;
    }
	this.move = function(n) {
            if(n > 8 || this.win() || this.board.charAt(n)=='X' || this.board.charAt(n)=='O') return false;
            this.board = this.board.substr(0,n) + this.player + this.board.substr(n+1,9-n);
            if(this.win()) return true;
            if(this.player == 'X')
                this.player='O';
            else
                this.player='X';
            return true;
    }
    this.who=function() {   return this.player; }
}

function Controller() {
    this.human = function(n) {
        if(model.win() || !model.move(n)) return;
        var button = 'button'+n;
        document.getElementById(button).object.setText('O');
        if(model.win()) 
            document.getElementById("Player").innerText = "O wins!";
        else 
            document.getElementById("Player").innerText = "X play";
            
        var feedURL = "http://"+host+":1490/?"+model.board;						// The feed to fetch
        // XMLHttpRequest setup code
        var xmlRequest = new XMLHttpRequest();
        xmlRequest.onload = function() { xmlLoaded(xmlRequest); };
        xmlRequest.open("GET", feedURL, true);
        xmlRequest.setRequestHeader("Cache-Control", "no-cache");
        xmlRequest.send(null);
    }
    this.computer = function(n) {
        if(!model.move(n)) return;
        var button = 'button'+n;
        document.getElementById(button).object.setText('X');
        if(model.win()) document.getElementById("Player").innerText = "X wins!";
        else document.getElementById("Player").innerText = "O play";
    }
}

// Callback when an XMLHttpRequest loads a feed; works with the XMLHttpRequest setup snippet
function xmlLoaded(xmlRequest) 
{
	if (xmlRequest.status == 200) {
        controller.computer(parseInt(xmlRequest.responseText));
	}
	else {
		alert("Error fetching data: HTTP status " + xmlRequest.status);
	}
}

function clickHandler0(event){    controller.human(0);}
function clickHandler1(event){    controller.human(1);}
function clickHandler2(event){    controller.human(2);}
function clickHandler3(event){    controller.human(3);}
function clickHandler4(event){    controller.human(4);}
function clickHandler5(event){    controller.human(5);}
function clickHandler6(event){    controller.human(6);}
function clickHandler7(event){    controller.human(7);}
function clickHandler8(event){    controller.human(8);}
