/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.cordova.AuthenticationToken;
import org.apache.cordova.CallbackServer;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaWebViewClient
extends WebViewClient {
    private static final String TAG = "Cordova";
    CordovaInterface cordova;
    CordovaWebView appView;
    private boolean doClearHistory = false;
    private Hashtable<String, AuthenticationToken> authenticationTokens = new Hashtable();

    public CordovaWebViewClient(CordovaInterface cordova) {
        this.cordova = cordova;
    }

    public CordovaWebViewClient(CordovaInterface cordova, CordovaWebView view) {
        this.cordova = cordova;
        this.appView = view;
    }

    public void setWebView(CordovaWebView view) {
        this.appView = view;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.appView.pluginManager == null || !this.appView.pluginManager.onOverrideUrlLoading(url)) {
            if (url.startsWith("tel:")) {
                try {
                    Intent intent = new Intent("android.intent.action.DIAL");
                    intent.setData(Uri.parse((String)url));
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error dialing " + url + ": " + e.toString());
                }
            } else if (url.startsWith("geo:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error showing map " + url + ": " + e.toString());
                }
            } else if (url.startsWith("mailto:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error sending email " + url + ": " + e.toString());
                }
            } else if (url.startsWith("sms:")) {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    String address = null;
                    int parmIndex = url.indexOf(63);
                    if (parmIndex == -1) {
                        address = url.substring(4);
                    } else {
                        address = url.substring(4, parmIndex);
                        Uri uri = Uri.parse((String)url);
                        String query = uri.getQuery();
                        if (query != null && query.startsWith("body=")) {
                            intent.putExtra("sms_body", query.substring(5));
                        }
                    }
                    intent.setData(Uri.parse((String)("sms:" + address)));
                    intent.putExtra("address", address);
                    intent.setType("vnd.android-dir/mms-sms");
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error sending sms " + url + ":" + e.toString());
                }
            } else if (url.startsWith("file://") || url.indexOf(this.appView.baseUrl) == 0 || this.appView.isUrlWhiteListed(url)) {
                if (this.appView.useBrowserHistory) {
                    return false;
                }
                this.appView.loadUrl(url);
            } else {
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.cordova.getActivity().startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    LOG.e(TAG, "Error loading url " + url, e);
                }
            }
        }
        return true;
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        AuthenticationToken token = this.getAuthenticationToken(host, realm);
        if (token != null) {
            handler.proceed(token.getUserName(), token.getPassword());
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (!this.appView.useBrowserHistory) {
            view.clearHistory();
            this.doClearHistory = true;
        }
        if (this.appView.callbackServer == null) {
            this.appView.callbackServer = new CallbackServer();
            this.appView.callbackServer.init(url);
        } else {
            this.appView.callbackServer.reinit(url);
        }
        this.appView.postMessage("onPageStarted", url);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        LOG.d(TAG, "onPageFinished(" + url + ")");
        if (this.doClearHistory) {
            view.clearHistory();
            this.doClearHistory = false;
        }
        ++this.appView.loadUrlTimeout;
        if (!url.equals("about:blank")) {
            this.appView.loadUrl("javascript:try{ cordova.require('cordova/channel').onNativeReady.fire();}catch(e){_nativeReady = true;}");
            this.appView.postMessage("onNativeReady", null);
        }
        this.appView.postMessage("onPageFinished", url);
        if (this.appView.getVisibility() == 4) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                        CordovaWebViewClient.this.cordova.getActivity().runOnUiThread(new Runnable(){

                            public void run() {
                                CordovaWebViewClient.this.appView.postMessage("spinner", "stop");
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t.start();
        }
        if (url.equals("about:blank")) {
            if (this.appView.callbackServer != null) {
                this.appView.callbackServer.destroy();
            }
            this.appView.postMessage("exit", null);
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        LOG.d(TAG, "CordovaWebViewClient.onReceivedError: Error code=%s Description=%s URL=%s", errorCode, description, failingUrl);
        ++this.appView.loadUrlTimeout;
        JSONObject data = new JSONObject();
        try {
            data.put("errorCode", errorCode);
            data.put("description", (Object)description);
            data.put("url", (Object)failingUrl);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.appView.postMessage("onReceivedError", data);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        String packageName = this.cordova.getActivity().getPackageName();
        PackageManager pm = this.cordova.getActivity().getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 128);
            if ((appInfo.flags & 2) != 0) {
                handler.proceed();
                return;
            }
            super.onReceivedSslError(view, handler, error);
        }
        catch (PackageManager.NameNotFoundException e) {
            super.onReceivedSslError(view, handler, error);
        }
    }

    public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
        if (!this.appView.peekAtUrlStack().equals(url)) {
            this.appView.pushUrl(url);
        }
    }

    public void setAuthenticationToken(AuthenticationToken authenticationToken, String host, String realm) {
        if (host == null) {
            host = "";
        }
        if (realm == null) {
            realm = "";
        }
        this.authenticationTokens.put(host.concat(realm), authenticationToken);
    }

    public AuthenticationToken removeAuthenticationToken(String host, String realm) {
        return this.authenticationTokens.remove(host.concat(realm));
    }

    public AuthenticationToken getAuthenticationToken(String host, String realm) {
        AuthenticationToken token = null;
        token = this.authenticationTokens.get(host.concat(realm));
        if (token == null) {
            token = this.authenticationTokens.get(host);
            if (token == null) {
                token = this.authenticationTokens.get(realm);
            }
            if (token == null) {
                token = this.authenticationTokens.get("");
            }
        }
        return token;
    }

    public void clearAuthenticationTokens() {
        this.authenticationTokens.clear();
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (url.contains("?") || url.contains("#")) {
            return this.generateWebResourceResponse(url);
        }
        return super.shouldInterceptRequest(view, url);
    }

    private WebResourceResponse generateWebResourceResponse(String url) {
        String ANDROID_ASSET = "file:///android_asset/";
        if (url.startsWith("file:///android_asset/")) {
            String niceUrl = url;
            niceUrl = url.replaceFirst("file:///android_asset/", "");
            if (niceUrl.contains("?")) {
                niceUrl = niceUrl.split("\\?")[0];
            } else if (niceUrl.contains("#")) {
                niceUrl = niceUrl.split("#")[0];
            }
            String mimetype = null;
            if (niceUrl.endsWith(".html")) {
                mimetype = "text/html";
            }
            try {
                AssetManager assets = this.cordova.getActivity().getAssets();
                Uri uri = Uri.parse((String)niceUrl);
                InputStream stream = assets.open(uri.getPath(), 2);
                WebResourceResponse response = new WebResourceResponse(mimetype, "UTF-8", stream);
                return response;
            }
            catch (IOException e) {
                LOG.e("generateWebResourceResponse", e.getMessage(), e);
            }
        }
        return null;
    }
}

