//
//  SecondViewController.m
//  VideoPlay
//
//  Created by Barbara Hecker on 8/10/12.
//  Copyright (c) 2012 International Technology University. All rights reserved.
//

#import "SecondViewController.h"

@interface SecondViewController ()

@end

@implementation SecondViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = NSLocalizedString(@"AudioVideo", @"AudioVideo");
        self.tabBarItem.image = [UIImage imageNamed:@"audio"];
    }
    return self;
}
							
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}





- (IBAction)audioStart:(UIButton *)sender {
    NSURL *url = [NSURL fileURLWithPath:[NSString stringWithFormat:@"%@/music.mp3", [[NSBundle mainBundle] resourcePath]]];
	
	NSError *error;
	player = [[AVAudioPlayer alloc] initWithContentsOfURL:url error:&error];
	player.numberOfLoops = -1;
	
	if (player == nil)
		NSLog([error description]);	
	else 
		[player play];}

- (IBAction)audioStop:(UIButton *)sender {
    [player stop];
}

- (IBAction)videoStart:(UIButton *)sender {
    NSString *urlStr = [[NSBundle mainBundle] pathForResource:@"video.mov" ofType:nil];
    NSURL *url = [NSURL fileURLWithPath:urlStr];
    moviePlayer = [[MPMoviePlayerController alloc] initWithContentURL:url];
    [self.view addSubview:moviePlayer.view];
    moviePlayer.view.frame = CGRectMake(0, 0, 320, 320);  
    [moviePlayer play];        
}

- (IBAction)videoStop:(UIButton *)sender {
    [moviePlayer stop];
}

- (IBAction)exitApp:(UIButton *)sender {
    exit(0);
}


@end
