//
//  ViewController.m
//  ImageTouch
//
//  Created by Barbara Hecker on 8/10/12.
//  Copyright (c) 2012 International Technology University. All rights reserved.
//

#import "ViewController.h"

@interface ViewController ()

@end

@implementation ViewController
@synthesize displayImage;

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)viewDidUnload
{
    [self setDisplayImage:nil];
    [super viewDidUnload];
    // Release any retained subviews of the main view.
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}


- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    
    NSSet *allTouches = [event allTouches];
    
    switch ([allTouches count]) {
        case 1: {
            
            UITouch *touch = [[allTouches allObjects] objectAtIndex:0];
            
            switch ([touch tapCount])
            {
                    
                case 1:
                {
                    timer = [NSTimer scheduledTimerWithTimeInterval:2 target:self
                                                           selector:@selector(showAlertView:) userInfo:nil repeats:NO];
                    
                } break;
                case 2: {
                    UITouch *touch1 = [[allTouches allObjects] objectAtIndex:0];
                    UITouch *touch2 = [[allTouches allObjects] objectAtIndex:1];
                    distance = [self distanceBetweenTwoPoints:[touch1 locationInView:[self view]]
                                                      toPoint:[touch2 locationInView:[self view]]];
                } break;
            }
        } break;
        case 2: {
        } break;
        default:
            break;
    }
    
}

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
    
    if([timer isValid])
        [timer invalidate];
    
    NSSet *allTouches = [event allTouches];
    
    switch ([allTouches count])
    {
        case 1: {
            UITouch *touch = [[allTouches allObjects] objectAtIndex:0];
            CGPoint centerPoint = [touch locationInView:[self view]];
            [displayImage setCenter:centerPoint];
        } break;
        case 2: {
            UITouch *touch1 = [[allTouches allObjects] objectAtIndex:0];
            UITouch *touch2 = [[allTouches allObjects] objectAtIndex:1];
            CGFloat finalDistance = [self distanceBetweenTwoPoints:[touch1   locationInView:[self view]]
                                                           toPoint:[touch2 locationInView:[self view]]];
            
            if(distance > finalDistance) {
            }
            else {
            }
            
        } break;
    }
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    
    if([timer isValid])
        [timer invalidate];
    
    NSSet *allTouches = [event allTouches];
    
    switch ([allTouches count])
    {
        case 1:
        {
            UITouch *touch = [[allTouches allObjects] objectAtIndex:0];
            
            switch([touch tapCount])
            {
                case 1:      
                    displayImage.contentMode = UIViewContentModeScaleAspectFit;
                    break;
                case 2:
                    displayImage.contentMode = UIViewContentModeCenter;
                    break;
            }
        }
            break;
    }
    [self Touches];
}

- (void) touchesCanceled {
    [self Touches];
}

- (CGFloat)distanceBetweenTwoPoints:(CGPoint)fromPoint toPoint:(CGPoint)toPoint {
    
    float x = toPoint.x - fromPoint.x;
    float y = toPoint.y - fromPoint.y;
    return sqrt(x * x + y * y);
}

- (void)Touches {
    distance = -1;
}

@end
