//
//  SecondViewController.m
//  HelloTabBar


#import "SecondViewController.h"
#import "DetailViewController.h"

@implementation SecondViewController
@synthesize dummyArray;

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [self setupArray];
    [super viewDidLoad];
}

- (void)setupArray {
    dummyArray = [[NSMutableArray alloc] init];
    [dummyArray addObject:@"Object 1"];
    [dummyArray addObject:@"Object 2"];
    [dummyArray addObject:@"Object 3"];
    [dummyArray addObject:@"Object 4"];
    [dummyArray addObject:@"Object 5"];
    [dummyArray addObject:@"Object 6"];
    [dummyArray addObject:@"Object 7"];
    [dummyArray addObject:@"Object 8"];
    [dummyArray addObject:@"Object 9"];
    [dummyArray addObject:@"Object 10"];
    [dummyArray addObject:@"Object 11"];
    [dummyArray addObject:@"Object 12"];
    [dummyArray addObject:@"Object 13"];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [dummyArray count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
    }
    
    cell.textLabel.text = [dummyArray objectAtIndex:indexPath.row];
    
    return cell;    
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *__strong)indexPath {
    DetailViewController *detail = [self.storyboard instantiateViewControllerWithIdentifier:@"Detail"];
    [self.navigationController pushViewController:detail animated:YES];
    
    detail.rowNum.text = [NSString stringWithFormat:@"This is row %d", (indexPath.row + 1)];
}


- (void)viewDidUnload
{
    [super viewDidUnload];
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
}

@end
